#include <irrlicht.h>
#include <chrono>
#include <thread>
#include <string>

class CMainClass : public irr::IEventReceiver {
  private:
    irr::IrrlichtDevice *m_pDevice;
    irr::video::IVideoDriver  *m_pDrv;
    irr::gui::IGUIEnvironment *m_pGui;

    irr::gui::IGUITreeView *m_pTree;
    irr::gui::IGUITreeView *m_pOther;
    irr::gui::IGUICheckBox *m_pAllow;
    
    void addTreeNodes(irr::gui::IGUITreeViewNode *a_pParent, int a_iLevel, int a_iParent, int &a_iCount) {
      for (int i = 0; i < 2; i++) {
        std::wstring l_sText = L"TreeNode " + std::to_wstring(++a_iCount);
        irr::gui::IGUITreeViewNode *l_pNode = a_pParent->addChildBack(l_sText.c_str(), 0, -1, -1);
        if (a_iLevel < 3) 
          addTreeNodes(l_pNode, a_iLevel + 1, i, a_iCount);

        l_pNode->setExpanded(true);
        l_pNode->setDragDropFlag(irr::gui::EGNDF_ALLOW_ALL);
      }
    }

  public:
    CMainClass() : m_pDevice(nullptr), m_pDrv(nullptr), m_pGui(nullptr), m_pTree(nullptr), m_pOther(nullptr), m_pAllow(nullptr) {
      m_pDevice = irr::createDevice(irr::video::EDT_OPENGL, irr::core::dimension2du(1680, 1024));

      if (m_pDevice) {
        m_pDevice->setWindowCaption(L"TreeView Test");
        m_pDevice->setEventReceiver(this);

        m_pDrv = m_pDevice->getVideoDriver();
        m_pGui = m_pDevice->getGUIEnvironment();

        irr::gui::IGUIFont *l_pFont = m_pGui->getFont("font.png");
        if (l_pFont != nullptr)
          m_pGui->getSkin()->setFont(l_pFont);
        else
          printf("Oops.");

        irr::u32 l_iHeight = m_pGui->getSkin()->getFont()->getDimension(L"X").Height;

        m_pTree  = m_pGui->addTreeView(irr::core::recti(100, 100, 800, 900));
        m_pAllow = m_pGui->addCheckBox(false, irr::core::recti(100, 95 - l_iHeight, 100 + l_iHeight, 95));

        m_pOther = m_pGui->addTreeView(irr::core::recti(900, 100, 1580, 900));
        m_pOther->getRoot()->addChildBack(L"Try to drop something here!");
        m_pOther->setDragDropFlags(irr::gui::EGTDF_ADD_AS_CHILD | irr::gui::EGTDF_ADD_AFTER | irr::gui::EGTDF_ADD_BEFORE);

        m_pGui->addStaticText(L" Allow Drag / Drop", irr::core::recti(100 + l_iHeight, 95 - l_iHeight, 1000, 95))->setTextAlignment(irr::gui::EGUIA_UPPERLEFT, irr::gui::EGUIA_CENTER);

        int i = 0;

        m_pTree->getRoot()->addChildBack(L"Cannot Drag")->setDragDropFlag(irr::gui::EGNDF_DROP_ALL);
        m_pTree->getRoot()->addChildBack(L"Cannot Drop")->setDragDropFlag(irr::gui::EGNDF_DRAG_NODE | irr::gui::EGNDF_DROP_INSERT_BEFORE | irr::gui::EGNDF_DROP_INSERT_AFTER);

        irr::gui::IGUITreeViewNode *l_pRoot = m_pTree->getRoot()->addChildBack(L"Root Node");

        addTreeNodes(l_pRoot, 0, -1, i);
        l_pRoot->setExpanded(true);
        l_pRoot->setDragDropFlag(irr::gui::EGNDF_DROP_ADD_CHILD);
      }
    }

    bool run() {
      if (m_pDevice->run()) {
        m_pDrv->beginScene(true, true, irr::video::SColor(255, 224, 224, 224));
        m_pGui->drawAll();
        m_pDrv->endScene();

        return true;
      }
      else return false;
    }

    virtual bool OnEvent(const irr::SEvent &a_cEvent) override {
      bool l_bRet = false;

      if (a_cEvent.EventType == irr::EET_MOUSE_INPUT_EVENT) {
        if (a_cEvent.MouseInput.Event == irr::EMIE_MOUSE_MOVED) {
          // irr::gui::IGUITreeViewNode *l_pNode = m_pTree->getNodeAt(irr::core::position2di(a_cEvent.MouseInput.X, a_cEvent.MouseInput.Y));
          // if (l_pNode != nullptr)
          //   printf("==> %ls\n", l_pNode->getText());
          // else
          //   printf("==> null\n");
        }

        irr::gui::EGET_TREEVIEW_NODE_COLLAPS;
      }
      else if (a_cEvent.EventType == irr::EET_GUI_EVENT) {
        if (a_cEvent.GUIEvent.EventType == irr::gui::EGET_TREEVIEW_NODE_DRAG) {
          if (m_pTree->getLastEventNode() != nullptr) {
            printf("Drag Node: %ls\n", m_pTree->getLastEventNode()->getText());
          }
          else printf("Nothing dragged\n");
        }
        else if (a_cEvent.GUIEvent.EventType == irr::gui::EGET_TREEVIEW_NODE_DROP) {
          if (m_pTree->getLastEventNode() != nullptr)
            printf("Drop Node: %ls\n", m_pTree->getLastEventNode()->getText());
          else
            printf("Nothing dropeed\n");
        }
        else if (a_cEvent.GUIEvent.EventType == irr::gui::EGET_TREEVIEW_DRAG_CANCELED) {
          printf("Dragging canceled\n");
        }
        else if (a_cEvent.GUIEvent.EventType == irr::gui::EGET_TREEVIEW_NODE_WILL_DROP) {
          printf("Node will be dropped\n");
        }
        if (a_cEvent.GUIEvent.EventType == irr::gui::EGET_CHECKBOX_CHANGED) {
          if (a_cEvent.GUIEvent.Caller == m_pAllow)
            m_pTree->setDragDropFlags(irr::gui::EGTDF_ALLOW_DRAG_DROP);
        }
      }

      return l_bRet;
    }
};

int main(void) {
  CMainClass l_cMain;

  std::chrono::steady_clock::time_point l_cNextStep = std::chrono::steady_clock::now();
  while (l_cMain.run()) {
    l_cNextStep = l_cNextStep + std::chrono::duration<int, std::ratio<1, 1000>>(16);
    std::this_thread::sleep_until(l_cNextStep);
  }
}